﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:                 *
*        Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the        *
*        documentation and/or other materials provided with the distribution.                                                                          *
*        Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this       *
*        software without specific prior written permission.                                                                                           *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/


using System.Text;

namespace SunriseSunset
{
	public class ReplaceSpaces
	{
		public static string RemoveSpaces(string line)
		{
			try
			{
                int startIndx = 3;
                int breakPoint = 9;
                int charCount = line.Length;
                while (startIndx < charCount)
                {
                    charCount = line.Length;

                    string subStr = line.Substring(startIndx, breakPoint);
                    int spaceCntr = subStr.Count(Char.IsWhiteSpace);
                    if (spaceCntr > 1)
                    {
                        subStr = line.Substring(startIndx, breakPoint - 4);
                        var stringBuilder = new StringBuilder(line);
                        stringBuilder.Remove(startIndx, breakPoint - 4);
                        stringBuilder.Insert(startIndx, "---- ----");
                        line = stringBuilder.ToString();
                    }
                    else
                    {
                        startIndx = startIndx + 10;
                    }
                }
                return line;
            }
            catch(Exception e)
			{
                throw new InvalidDataException("Error occured while formatting the data.", e);
			}
		}

        public static string AddSpaces(string line)
        {
            try
            {
                int startIndx = 0;
                int breakPoint = 3;
                bool startSpaceAdded = true;
                int add = 2;
                int charCount = line.Length;
                while(startIndx < charCount)
                {
                    charCount = line.Length;
                    string subStr = line.Substring(startIndx, breakPoint);
                    if (subStr.Contains('-'))
                    {
                        subStr = subStr.Replace('-', ' ');
                    }
                    var stringBuilder = new StringBuilder(line);
                    stringBuilder.Remove(startIndx, breakPoint);
                    stringBuilder.Insert(startIndx, subStr + " ");
                    line = stringBuilder.ToString();
                    if (startSpaceAdded)
                    {
                        startIndx = 4;
                        breakPoint = 9;
                        startSpaceAdded = false;
                    }
                    else
                    {
                        startIndx = startIndx + breakPoint + add;
                    }
                }
                return line;
            } 
            catch(Exception e)
            {
                throw new InvalidDataException("Error occurred while formatting the data.", e);
            }
        }
	}
}