﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:                 *
*        Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the        *
*        documentation and/or other materials provided with the distribution.                                                                          *
*        Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this       *
*        software without specific prior written permission.                                                                                           *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/


using static System.Console;
using HtmlAgilityPack;

namespace SunriseSunset
{
	public class FileOperations
	{
		public static async Task DownloadData(string currentYear, string latitude, string longitude, string timeZoneHour, string sign)
		{
			try
			{
                using HttpClient http = new();
                string baseUri = "https://aa.usno.navy.mil/calculated/rstt/year";
                string year = currentYear;
                string task = "0";
                string lat = latitude;
                string lon = longitude;
                string timeZone = timeZoneHour;
                string timeZoneSign = sign;
                string uri = $"{baseUri}?ID=AA&year={year}&task={task}&lat={lat}&lon={lon}&label=&tz={timeZone}&tz_sign={timeZoneSign}&submit=Get+Data";
                HttpResponseMessage res = await http.GetAsync(uri);
                res.EnsureSuccessStatusCode();
                string content = await res.Content.ReadAsStringAsync();
                string filePath = Directory.GetCurrentDirectory() + "/SunriseSunset" + year + ".txt";
                HtmlDocument doc = new();
                doc.LoadHtml(content);
                HtmlNode preNode = doc.DocumentNode.SelectSingleNode("//pre");
                string preText = preNode.InnerText;
                await File.WriteAllTextAsync(filePath, preText);
                WriteLine("File downloaded!!!");
            } 
			catch(Exception e)
			{
				throw new HttpRequestException("There was issue in downloading data from the specified URL.", e);
			}
		}

		public static bool CheckFileOnPath(string file)
		{
			try
			{
				bool isFilePresent = false;
				if (File.Exists(file))
				{
					isFilePresent = true;
				}
				else
				{
					isFilePresent = false;
				}
                return isFilePresent;
			} 
			catch(Exception e)
			{
				throw new FileNotFoundException("File not found on the specified path.", e);
			}
		}
	}
}