﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:                 *
*        Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the        *
*        documentation and/or other materials provided with the distribution.                                                                          *
*        Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this       *
*        software without specific prior written permission.                                                                                           *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/


using Microsoft.Data.SqlClient;
using static System.Console;

namespace SunriseSunset
{
	public class SqlOperations
    {
		public static bool CheckYear(string currYear, SqlConnection con)
		{
			try
			{
				bool checkValid = false;
				SqlCommand cmd = new("SELECT DISTINCT(YEAR(dateToday)) as yr from dbo.SunriseSunset;", con);
				using(SqlDataReader reader = cmd.ExecuteReader())
				{
					if (reader.HasRows)
					{
						while (reader.Read())
						{
							if (currYear.Equals(reader["yr"].ToString()))
							{
								WriteLine("Data is already present for the year " + reader["yr"].ToString());
								WriteLine("Type Y to overwrite the current data or N to move forward.");
								string? userInput = ReadLine();

								if (userInput != null && (userInput.Trim().Equals("Y") || userInput.Trim().Equals("y")))
								{
                                    checkValid = true;
								}
								else
								{
                                    checkValid = false;
								}
							}
							else
							{
                                checkValid = true;
							}
						}
					}
					else
					{
                        checkValid = true;
					}
				}
                return checkValid;
            } 
			catch(Exception e)
			{
				throw new IOException("Error occurred while retrieving data from database.", e);
			}
		}

		public static void TruncateData(SqlConnection con, string currYear)
		{
			try
			{
				SqlCommand truncate = new("DELETE dbo.SunriseSunset where YEAR(dateToday) = @currYear;", con);
				truncate.Parameters.AddWithValue("@currYear", currYear);
				int val = truncate.ExecuteNonQuery();
			} 
			catch(Exception e)
			{
				throw new InvalidOperationException("The table truncate operation was not successful.", e);
			}
		}

		public static int ReturnDataCount(SqlConnection con, string currYear)
		{
			try
			{
				int countVal = 0;
                SqlCommand count = new("SELECT COUNT(*) as dataCount FROM dbo.SunriseSunset where YEAR(dateToday) = @currYear;", con);
                count.Parameters.AddWithValue("@currYear", currYear);
				using (SqlDataReader reader = count.ExecuteReader())
				{
					if (reader.HasRows)
					{
						while (reader.Read())
						{
							countVal = (int)reader["dataCount"];
						}
					}
				}
                return countVal;
			}
			catch(Exception e)
			{
				throw new InvalidOperationException("Could not perform the record count operation.", e);
			}
		}

        //internal static bool CheckYear(string currentYear, SqlConnection connect)
        //{
        //    throw new NotImplementedException();
        //}
    }
}