﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:                 *
*        Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the        *
*        documentation and/or other materials provided with the distribution.                                                                          *
*        Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this       *
*        software without specific prior written permission.                                                                                           *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/


/****************************************
 *   This does not yet adjust for DST.  *
 * *************************************/

using static System.Console;
using Microsoft.Data.SqlClient;
using System.Runtime.InteropServices;

namespace SunriseSunset
{
    class Program
    {
        private static readonly GettingYear getYear = new();
        static string? currentYear;
        static StreamReader? myReader;
        [DllImport("kernel32.dll", ExactSpelling = true)]
        private static extern IntPtr GetConsoleWindow();
        private static IntPtr ThisConsole = GetConsoleWindow();
        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        private static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);
        private const int HIDE = 0;
        private const int MAXIMIZE = 3;
        private const int MINIMIZE = 6;
        private const int RESTORE = 9;

        public static async Task Main()
        {
            //  ShowWindow(ThisConsole, MAXIMIZE);
            ConsoleColor existingForeground = ForegroundColor;
            ConsoleColor existingBackground = BackgroundColor;
            ForegroundColor = ConsoleColor.White;
            BackgroundColor = ConsoleColor.Blue;
            Clear();
            //  getting the current year
            currentYear = GettingYear.ReturnYear();
            GetDataFromUser getData = new();
            (string yearFromUser, string latitude, string longitude, string timeZoneOffset, string timeZoneSign) = getData.ReturnYearFromUser();
            if (yearFromUser != null)
            {
                currentYear = yearFromUser;
            }
            //  download file from URL
            string file = Directory.GetCurrentDirectory() + @"/SunriseSunset" + currentYear + ".txt";
            FileOperations sourceData = new();
            if (!FileOperations.CheckFileOnPath(file))
            {
                await FileOperations.DownloadData(currentYear, latitude, longitude, timeZoneOffset, timeZoneSign);
            }
            myReader = new(Directory.GetCurrentDirectory() + @"/SunriseSunset" + currentYear + ".txt");
            //  extracting the data from the text file
            List<List<string>> cols = DataExtraction();
            WriteLine("Data extraction from text file completed!!!");
            //  connecting to the SQL database
            SqlConnection connect = ConnectSql();
            WriteLine("SQL Connection established!!!");
            //  check for the current year before inserting the data
            SqlOperations isValid = new();
            //  inserting the data into the SQL table
            if (SqlOperations.CheckYear(currentYear, connect))
            {
                if(SqlOperations.ReturnDataCount(connect, currentYear) > 0)
                {
                    SqlOperations.TruncateData(connect, currentYear);
                }                
                DataInsertion(cols, connect, currentYear, myReader);
                WriteLine("Data inserted into the database successfully!!!");
            }
            //  displaying the output onto console window
            _ = new DisplayOutput();
            WriteLine("The output is as below:");
            DisplayOutput.ShowOutput(cols);
            ForegroundColor = existingForeground;
            BackgroundColor = existingBackground;
            Clear();
            ShowWindow(ThisConsole, RESTORE);
        }

        public static List<List<string>> DataExtraction()
        {
            string line = "";
            ReplaceSpaces spcReplc = new();
            List<List<string>> columns = new();
            try
            {
                while (line != null)
                {
                    line = myReader?.ReadLine() ?? string.Empty;
                    if(line != "")
                    {
                        if ((line != null) && (line.Substring(0, 2) != "01"))
                            continue;
                        else
                        {
                            break;
                        }
                    }
                }
                //  using the above 'line', we replace two spaces with single space. Using the space count we determine whether
                //  a line has some empty values for sunrise/sunset or not
                //  the values are then split based on that single space and using the List<List<string>>, these separated values
                //  are transferred to this list
                for (int i = 0; i < 31; i++)
                {
                    string[] lines = Array.Empty<string>();
                    if (line != null)
                    {
                        line = line.Replace("  ", " ");
                        lines = line.Split('\n');
                        foreach (string line1 in lines)
                        {
                            int spaceCount = line1.Count(Char.IsWhiteSpace);
                            if (spaceCount > 24)
                            {
                                line = ReplaceSpaces.RemoveSpaces(line1);
                            }
                            //  remove leading/trailing whitespaces and split the line by multiple whitespaces
                            string[] values = line.Trim().Split(new[] { ' ' });
                            for (int x = 0; x < values.Length; x++)
                            {
                                if (columns.Count <= x)
                                {
                                    columns.Add(new List<string>());
                                }
                                columns[x].Add(values[x]);
                            }
                        }
                        //  once all the values are put into the list, it is joined back
                        line = myReader?.ReadLine() ?? string.Empty;
                    }
                }
            } 
            catch(Exception e)
            {
                throw new IOException("An error occurred while reading or processing the file.", e);
            }
            return columns;
        }

        public static SqlConnection ConnectSql()
        {
            string connectionString;
            _ = new SqlConnection();
            SqlConnection con;
            try
            {
                //  creating the connection
                connectionString = "Server = System76; Database = ep5BAStest; Integrated Security = SSPI; TrustServerCertificate = true";
                con = new SqlConnection(connectionString);
                con.Open();
            }
            catch (SqlException e)
            {
                throw new InvalidOperationException("The SQL connection could not be established. Please check the connection string.", e);
            }
            return con;
        }

        public static void DataInsertion(List<List<string>> columns, SqlConnection con, String currYear, StreamReader lineReader)
        {
            try
            {
                int month = 1;
                string? dayWise = columns[0].ToString();
                int startIndx = 1;
                int endIndx = 2;
                //  outer loop for the number of months
                for (int months = 0; months < 12; months++)
                {
                    //  inner loop for the number of days that are present on the 0th position of the list.
                    for (int col = 0; col < columns[0].Count; col++)
                    {
                        string dateToday = month.ToString() + "/" + columns[0][col].ToString() + "/" + currYear;
                        string sunrise = string.Concat(columns[startIndx][col].AsSpan(0, 2), ":", columns[startIndx][col].AsSpan(2, 2));
                        string sunset = string.Concat(columns[endIndx][col].AsSpan(0, 2), ":", columns[endIndx][col].AsSpan(2, 2));
                        if (!sunrise.Contains('-'))
                        {
                            SqlCommand insert = new SqlCommand("INSERT INTO dbo.SunriseSunset (dateToday, sunrise, sunset) values (@date, @sunRise, @sunSet);", con);
                            insert.Parameters.AddWithValue("@date", dateToday);
                            insert.Parameters.AddWithValue("@sunRise", sunrise);
                            insert.Parameters.AddWithValue("@sunSet", sunset);
                            insert.ExecuteNonQuery();
                        }
                    }
                    month++;
                    startIndx += 2;
                    endIndx += 2;
                }
            }
            catch (Exception e)
            {
                throw new InvalidDataException("Error occurred while inserting the data. Please check the file/s.", e);
            }
            finally
            {
                lineReader.Close();
                con.Close();
            }
        }
    }
}