﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:                 *
*        Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the        *
*        documentation and/or other materials provided with the distribution.                                                                          *
*        Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this       *
*        software without specific prior written permission.                                                                                           *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/


using static System.Console;
using Newtonsoft.Json.Linq;

namespace SunriseSunset
{
    public class GetDataFromUser
    {
        public (string Year, string Latitude, string Longitude, string TimeZoneOffset, string TimeZoneSign) ReturnYearFromUser()
        {
            Write("Please enter a year:  ");
            string year = ReadLine()!;
            while (!IsValidYear(year))
            {
                WriteLine("Entered year is either greater than 2100 or less than 1700. Please specify between this range");
                WriteLine("Please enter a valid year:");
                year = ReadLine()!;
            }
            Write("Please enter the latitude value as numerical value, such as 43.02  ");
            string latitude = ReadLine()!;
            Write("Please enter a longitude value as numerical value, such as -77.75  ");
            string longitude = ReadLine()!;
            string timeZoneOffset = "0";
            string timeZoneSign = "0";
            if (Convert.ToDouble(longitude) != 0)
            {
                Write("Please enter the time zone offset from Greenwich Time, such as 4.25  ");
                timeZoneOffset = ReadLine()!;
                WriteLine("Press 'E' for east, 'W' for west direction. Press 'Q' to quit.");
                string? input = ReadLine()?.ToUpper();
                while (input != "E" && input != "W" && input != "Q")
                {
                    WriteLine("Invalid input. Please enter 'E', 'W', or 'Q':");
                    input = ReadLine()?.ToUpper();
                }
                if (input == "E")
                {
                    timeZoneSign = "1";
                }
                else if (input == "W")
                {
                    timeZoneSign = "-1";
                }
                else if (input == "Q")
                {
                    Environment.Exit(0);
                }
            }
            return (year, latitude, longitude, timeZoneOffset, timeZoneSign);
        }

        private static bool IsValidYear(string year)
        {
            if (!int.TryParse(year, out int yearValue))
            {
                return false;
            }
            return yearValue >= 1700 && yearValue <= 2100;
        }
    }
}
