﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:                 *
*        Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the        *
*        documentation and/or other materials provided with the distribution.                                                                          *
*        Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this       *
*        software without specific prior written permission.                                                                                           *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/


using static System.Console;

namespace SunriseSunset
{
	public class DisplayOutput
	{
        public static void ShowOutput(List<List<String>> cols)
		{
            try
            {
                ReplaceSpaces spc = new();
                List<List<string>> rows = new();
                for (int x = 0; x < cols.Count; x++)
                {
                    string? line = string.Join(" ", cols[x]);
                    string[]? values = line.Split(new[] { ' ' });
                    for (int y = 0; y < values.Length; y++)
                    {
                        if (rows.Count <= y)
                        {
                            rows.Add(new List<string>());
                        }
                        rows[y].Add(values[y]);
                    }
                }
                for (int j = 0; j < rows.Count; j++)
                {
                    WriteLine(ReplaceSpaces.AddSpaces(string.Join(" ", rows[j])));
                }
            } 
            catch(Exception e)
            {
                throw new InvalidDataException("Error occurred while displaying data.", e);
            }
            finally
            {
                Write("\n\nPress the <ANY> key to continue...");
                _ = ReadKey(true);
            }
        }
    }
}