﻿/*******************************************************************************************************************************************************
*    All Project Files Copyright © 2025 by The ep5 Educational Broadcasting Foundation                                                                 *
*                                                                                                                                                      *
*    Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:    *
*                                                                                                                                                      *
*        →  Redistributions of source code must retain the above copyright notice, this list of conditions, and the following disclaimer:              *
*        →  Redistributions in binary form must reproduce the above copyright notice, this list of conditions, and the following disclaimer in the     *
*           documentation and/or other materials provided with the distribution.                                                                       *
*        →  Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this    *
*           software without specific prior written permission.                                                                                        *
*                                                                                                                                                      *
*    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED     *
*    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO  EVENT SHALL THE COPYRIGHT HOLDER OR     *
*    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,         *
*    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF         *
*    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT, INCLUDING NEGLIGENCE OR OTHERWISE, ARISING IN ANY WAY OUT OF THE USE OF THIS           *
*    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                                      *
*******************************************************************************************************************************************************/

//  Written 6 June 2025 by David Fisher
//  Copyright © 2025 by The ep5 Educational Broadcasting Foundation; all rights reserved

//  This demo program connects to a Sealevel type 463E-OEM I/O processor https://www.sealevel.com/seai-o-463e-oem/
//  Note: this program utilizes the proprietary Sealevel API for access to the hardware

//  The code, as written, assumes that the I/O processor is connected to four 24-point opto-rack boards, populated
//  with sixty-four digital outputs and thirty-two digital inputs

using static System.Console;

namespace SeaMAXdemo
{
    class Program
    {
        public const int SUCCESS = 0;

        static int Main(string[] args)
        {
            int errorCode;

            BackgroundColor = ConsoleColor.Blue;
            ForegroundColor = ConsoleColor.White;
            Clear();
            WriteLine("\nInitializing everything . . . please wait; this will not take long.\n");

            //  zero the data array to be written and initialize the I/O controller
            Array.Clear(Data.SeaMAXdata, 0, Data.SeaMAXdata.Length);
            errorCode = Initializer.InitializeIO(ref Data.SeaMAXdata);
            if (errorCode != SUCCESS)
            {
                WriteLine("Failed initialization; program terminates here...");
                WriteLine("Error reported is: {0}\n", errorCode);
                return errorCode;
            }

            ForegroundColor = ConsoleColor.Red;
            BackgroundColor = ConsoleColor.White;
            WriteLine("To stop the run and end the program, press the \u201CQ\u201D key.");
            ForegroundColor = ConsoleColor.White;
            BackgroundColor = ConsoleColor.Blue;

            TestEventLoop.RunTest();
            
            //	reset the eight digital output ports to OFF
            WriteLine("Setting all outputs to OFF.");
            Data.SeaMAXdata[0] = 0;
            Data.SeaMAXdata[1] = 0;
            Data.SeaMAXdata[2] = 0;
            Data.SeaMAXdata[3] = 0;
            Data.SeaMAXdata[4] = 0;
            Data.SeaMAXdata[5] = 0;
            Data.SeaMAXdata[6] = 0;
            Data.SeaMAXdata[7] = 0;
            errorCode = WriteToController.WriteIOcontroller();
            if (errorCode < 0)
            {
                WriteLine("\n\nWriting the digital outputs returned error code: {0}\n\n", errorCode);
                _ = ReadKey();
            }
            else
                WriteLine("\nProgram ends here...\n");
            return errorCode;
        }
    }
}

