﻿/**************************************************************************************************
 *                                                                                                * 
 *  Herein dwelleth the main event loop wherein wondrous things are made to occur. Yeah...right.  *
 *                                                                                                *
 *************************************************************************************************/                                                                                                

using static System.Console;
using System.Data.SqlClient;
using System.Collections;

namespace ep5BAS
{
    public class MainEventLoop
    {
        public static int ProcessRecipe()
        {
            int returnCode;

            WriteLine("Starting the recipe...\n");
            //  read the input and output states from the I/O controller and populate the arrays with the results
            returnCode = ReadFromController.ReadIOcontroller();     //  for now, this is a placeholder
            if (returnCode < 0)
            {
                WriteLine("Error in reading inputs and outputs from the I/O controller.");
                WriteLine("The error code is {0}.", returnCode);
                return returnCode;
            }

            //  main event loop
            while (true)
            {
                //  read the digital inputs
                ReadFromController.ReadIOcontroller();

                //  disassemble the input byte array
                Disassemble.TheInputArray();

                //  apply the program logic
                ProcessThe.BusinessRules();

                //  assemble the output byte array
                Assemble.TheOutputArray();

                //  write the digital outputs only if something has changed
                if (!Data.SeaMAXdata.AsSpan().SequenceEqual(Data.previousSeaMAXdata))
                {
                    WriteToController.WriteIOcontroller();
                    //  save the output state as written
                    Data.previousSeaMAXdata = (byte[])Data.SeaMAXdata.Clone();
                }

                if (KeyAvailable)
                {
                    //  insert dialogue requesting confirmation of program termination
                    //  put into parallel thread, allowing main event loop to continue
                    //      running while awaiting operator confirmation
                    char c = ReadKey(true).KeyChar;
                    if ((c == 'q') || (c == 'Q'))
                        break;
                }
            }
            return 0;
        }
    }
}
