﻿using System;
using static System.Console;
using Modbus.Device;                                                 // Hard dependency on Nmodbus4
using System.Net.Sockets;

namespace ProtosXdigitalDemo
{
    internal class WriteMachineDigitalStateToIO
    {
        public static byte WriteMachineStateToIO(ModbusIpMaster master, ushort coilOutputStartAddress)
        {
            try
            {
                master.WriteMultipleCoils(coilOutputStartAddress, Data.MachineState.digitalOutputChannels);
            }
            catch (Exception ex)
            {
                WriteLine($"Error writing discrete outputs: {ex.Message}");
                _ = ReadKey(true);
                return Data.MachineState.failureCode[1];
            }
            return Data.MachineState.failureCode[0];
        }
    }
}
