﻿using Modbus.Device;
using static System.Console;

namespace ProtosXdemo
{
    internal class MainEventLoop
    {
        static public int RunEventLoop(ModbusIpMaster modbusMaster, ushort coilOutputStartAddress)
        {
            WriteLine("\nTurning all the outputs OFF...");                                          // start with known state = all outputs OFF
            int shutdownErrorCode = MakeHardStop.HardStop(modbusMaster, coilOutputStartAddress);    // write the machine state values to the I/O hardware and check for success
            if (shutdownErrorCode == Data.MachineState.failureCode[0])      
            {
                WriteLine("All digital outputs have been turned OFF");
                WriteLine("Program begins running here");
            }
            else
            {
                WriteLine("Program fails here...");
                return shutdownErrorCode;
            }
            WriteLine("Main event loop starts here . . . press the 'Q' key to stop the program run");
            for (int ndx = 0; ndx < 4; ndx++)
            {
                if (KeyAvailable)
                {
                    char c = ReadKey(true).KeyChar;
                    if ((c == 'q') || (c == 'Q'))
                    {
                        MakeHardStop.HardStop(modbusMaster, coilOutputStartAddress);
                        break;
                    }
                }
                WriteLine("Turning all the outputs ON...");
                for (byte indx = 0; indx < 16; indx++)                   // set machine state values to all outputs ON
                {
                    Data.MachineState.digitalOutputChannels[indx] = true;
                }
                if (WriteMachineDigitalStateToIO.WriteMachineStateToIO(modbusMaster, coilOutputStartAddress) == Data.MachineState.failureCode[0])      // write the machine state values to the I/O hardware
                {
                    WriteLine("All digital outputs are now ON");
                }
                else
                {
                    WriteLine("Writing machine-state variable failed...press the <ANY> key to end the program");
                    _ = ReadKey(true);
                    return Data.MachineState.failureCode[1];
                }
                Thread.Sleep(250);
                WriteLine("Turning all the outputs OFF...");
                MakeHardStop.HardStop(modbusMaster, coilOutputStartAddress);
                Thread.Sleep(250);
            }
            for (int ndx = 0; ndx < 40; ndx++)
            {
                LoadMachineStateDigital.MakeRandomStateDigital();
                if (WriteMachineDigitalStateToIO.WriteMachineStateToIO(modbusMaster, coilOutputStartAddress) == Data.MachineState.failureCode[0])      // write the machine state values to the I/O hardware
                {
                    WriteLine("All digital outputs are now ON");
                }
                else
                {
                    WriteLine("Writing machine-state variable failed...press the <ANY> key to end the program");
                    _ = ReadKey(true);
                    return Data.MachineState.failureCode[1];
                }
                Thread.Sleep(250);
            }
            return Data.MachineState.failureCode[0];
        }
    }
}
