﻿
namespace ProtosXdemo
{
    public static class Data
    {
        public static class MachineState
        {
            public static bool[] digitalInputChannels = new bool[16];       // digital inputs on PX-149 terminal
            public static bool[] digitalOutputChannels = new bool[16];      // digital outputs on PX-249 terminal
            public static int[] analogue420inputs = new int[8];             // analogue inputs (status and data) 4-20ma on PX-304
            public static int[] analogue420outputs = new int[4];            // analogue outputs (control and data) 4-20ma on PX-404
            public static int[] analogueTC1inputs = new int[4];             // analogue inputs (status and data) J T/C on PX-332J (first)
            public static int[] analogueTC2inputs = new int[4];             // analogue inputs (status and data) J T/C on PX-332J (second)
            public static int[] analogueRTD1inputs = new int[4];            // analogue inputs (status and data) RTD on PX-322-1 (first)
            public static int[] analogueRTD2inputs = new int[4];            // analogue inputs (status and data) RTD on PX-322-1 (second)
            public static byte[] failureCode = new byte[256];               // 0 = success; 1 - 255 = specific failure
            public static ushort numberOfDigitalInputs;                     // number of discrete inputs to read
            public static ushort numberOfDigitalOutputs;                    // number of discrete outputs to write
            public static ushort numberOfAnalogueInputs;                    // number of analogue inputs to read
            public static ushort numberOfAnalogueOutputs;                   // number of analogue outputs to write

        }
        enum DigitalInputChannels                                           // temporary name values
        {
            DigitalInput0,
            DigitalInput1,
            DigitalInput2,
            DigitalInput3,
            DigitalInput4,
            DigitalInput5,
            DigitalInput6,
            DigitalInput7,
            DigitalInput8,
            DigitalInput9,
            DigitalInput10,
            DigitalInput11,
            DigitalInput12,
            DigitalInput13,
            DigitalInput14,
            DigitalInput15
        }
        enum DigitalOutputChannels                                          // application-specific names
        {
            KitchenLight1,
            KitchenLight2,
            KitchenLight3,
            PorchLight1,
            Porchlight2,
            OutsideFloodlight1,
            OutsideFloodlight2,
            PantryLight1,
            FrontRoomLight1,
            FrontRoomLight2,
            FrontRoomLight3,
            Radio,
            LandingLight1,
            ServerRoomLights,
            HallLight1,
            HallLight2
        }
        enum AnalogueInputs420                                              // temporary name values
        {
            Input420_1,
            Input420_2,
            Input420_3,
            Input420_4
        }
        enum AnalogueOutput420                                              // temporary name values
        {
            Output420_1,
            Output420_2,
            Output420_3,
            Output420_4
        }
        public enum  AnalogueInputsTC1                                       // application-specific names
        {
            TestTcTemp1_1,
            TestTcTemp1_2,
            TestTcTemp1_3,
            TestTcTemp1_4
        }
        public enum AnalogueInputsTC2                                       // application-specific names
        {
            TestTcTemp2_1,
            TestTcTemp2_2,
            TestTcTemp2_3,
            TestTcTemp2_4
        }
        public enum AnalogueInputsRTD1                                      // application-specific names
        {
            TestRtdTemp1_1,
            TestRtdTemp1_2,
            TestRtdTemp1_3,
            TestRtdTemp1_4
        }
        public enum AnalogueInputsRTD2                                      // application-specific names
        {
            TestRtdTemp2_1,
            TestRtdTemp2_2,
            TestRtdTemp2_3,
            TestRtdTemp2_4
        }
    }
}
